IF EXISTS (SELECT name FROM master.sys.databases WHERE name = N'HumanResources')
  BEGIN
	DROP DATABASE HumanResources
  END


CREATE DATABASE HumanResources
GO

USE HumanResources

/****** Object:  Table [dbo].[Employees]    Script Date: 08/14/2013 19:32:02 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[Employees](
	[EmployeeID] [int] IDENTITY(1,1) NOT NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NULL,
	[Title] [varchar](50) NOT NULL,
	[BirthDate] [date] NOT NULL,
	[MaritalStatus] [char](1) NOT NULL,
	[Gender] [char](1) NOT NULL,
	[HireDate] [date] NOT NULL,
	[Salary] [money] NULL,
	[VacationHours] [smallint] NOT NULL,
	[SickLeaveHours] [smallint] NOT NULL,
	[Active] [char](3) NOT NULL,
	[ManagerID] [int] NULL,
	[ModifiedDate] [datetime] NOT NULL,
 CONSTRAINT [PK_Employee] PRIMARY KEY CLUSTERED 
(
	[EmployeeID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


/**********************************************************************************************************/



SET IDENTITY_INSERT EMPLOYEES ON



INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (2,'Kevin', 'F', 'Brown', 'Marketing Assistant', '06/03/1977', 'S', 'M', '02/26/1997', 23799.93,42,41,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (3,'Roberto', Null, 'Tamburello', 'Engineering Manager', '12/13/1964', 'M', 'M', '12/12/1997', 44999.97,2,21,'Yes',12,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (5,'Thierry', 'B', 'D''Nofro', 'Tool Designer', '08/29/1949', 'M', 'M', '01/11/1998', 28730.00,9,24,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (6,'David', 'M', 'Bradley', 'Marketing Manager', '04/19/1965', 'S', 'M', '01/20/1998', 42500.02,40,40,'Yes',109,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (9,'Gail', 'A', 'Erickson', 'Design Engineer', '10/29/1942', 'M', 'F', '02/06/1998', 66299.98,5,22,'Yes',3,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (11,'Jossef', 'H', 'Goldberg', 'Design Engineer', '04/11/1949', 'M', 'M', '02/24/1998', 37569.99,6,23,'Yes',3,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (12,'Terri', 'Lee', 'Duffy', 'Vice President of Engineering', '09/01/1961', 'S', 'F', '03/03/1998', 85799.95,1,20,'Yes',109,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (28,'Ashvini', 'R', 'Sharma', 'Network Administrator', '04/28/1967', 'S', 'M', '01/05/1999', 42500.02,70,55,'Yes',150,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (30,'Paula', 'M', 'Barreto de Mattos', 'Human Resources Manager', '03/14/1966', 'M', 'F', '01/07/1999', 67999.98,54,47,'Yes',140,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (34,'          Susan    ', 'W', 'Eaton', 'Stocker', '03/20/1968', 'S', 'F', '01/08/1999', 15724.80,99,68,'Yes',85,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (35,'Vamsi', 'N', 'Kuppa', 'Shipping and Receiving Clerk', '04/19/1967', 'M', 'M', '01/08/1999', 14108.64,95,67,'Yes',85,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (41,'Peng', 'J', 'Wu', 'Quality Assurance Supervisor', '04/19/1966', 'M', 'M', '01/10/1999', 32129.98,81,60,'Yes',200,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (42,'Jean', 'E', 'O''Brien', 'Information Services Manager', '01/13/1966', 'S', 'F', '01/12/1999', 126000.07,65,52,'Yes',109,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (44,'A. Scott', Null, 'Wright', 'Master Scheduler', '10/19/1958', 'S', 'M', '01/13/1999', 41650.02,44,42,'Yes',148,'01/26/2005')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (46,'Sariya', 'E', 'Harnpadoungsataya', 'Marketing Specialist', '06/21/1977', 'S', 'M', '01/13/1999', 25500.04,45,42,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (47,'Willis', 'T', 'Johnson', 'Recruiter', '08/18/1968', 'S', 'M', '01/14/1999', 32299.95,99,44,'Yes',30,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (49,'Christian', 'E', 'Kleinerman', 'Maintenance Supervisor', '02/18/1966', 'M', 'M', '01/15/1999', 30345.01,92,66,'Yes',218,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (54,'Tengiz', 'N', 'Kharatishvili', 'Control Specialist', '05/29/1980', 'S', 'M', '01/17/1999', 24989.96,76,58,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (59,'Deborah', 'E', 'Smyth', 'Accounts Receivable Specialist', '04/07/1966', 'M', 'F', '01/19/1999', 23712.00,60,50,'Yes',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (66,'Janaina', 'Barreiro Gambaro', 'Bueno', 'Application Specialist', '03/03/1975', 'M', 'F', '01/24/1999', 47879.92,71,55,'Yes',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (70,'Mindy', 'C', 'Martin', 'Benefits Specialist', '12/22/1974', 'M', 'F', '01/26/1999', 41399.90,51,45,'Yes',30,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (71,'Wendy', 'Beth', 'Kahn', 'Finance Manager', '11/12/1974', 'S', 'F', '01/26/1999', 107999.93,55,47,'Yes',140,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (72,'Kim', 'T', 'Ralls', 'Stocker', '06/01/1974', 'S', 'F', '01/27/1999', 15724.80,98,69,'Yes',85,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (77,'Sean', 'P', 'Alexander', 'Quality Assurance Technician', '04/07/1966', 'S', 'M', '01/29/1999', 15707.96,82,61,'No ',41,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (79,'Diane', 'L', 'Margheim', 'Research and Development Engineer', '07/06/1976', 'S', 'F', '01/30/1999', 102000.04,62,51,'Yes',158,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (82,'Vidur', 'X', 'Luthra', 'Recruiter', '09/02/1974', 'S', 'M', '02/02/1999', 32299.95,50,45,'Yes',30,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (85,'Pilar', 'G', 'Ackerman', 'Shipping and Receiving Supervisor', '10/11/1962', 'S', 'M', '02/03/1999', 28560.04,93,66,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (94,'Candy', 'L', 'Spoon', 'Accounts Receivable Specialist', '03/26/1966', 'S', 'F', '02/07/1999', 47424.00,61,50,'No ',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (96,'William', 'S', 'Vong', 'Scheduling Assistant', '12/08/1971', 'M', 'M', '02/08/1999', 15240.16,45,42,'Yes',44,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (102,'Dan', 'K', 'Bacon', 'Application Specialist', '07/28/1971', 'M', 'M', '02/12/1999', 40697.93,72,56,'Yes',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (106,'Mary', 'E', 'Gibson', 'Marketing Specialist', '10/14/1952', 'M', 'F', '02/13/1999', 45000.08,46,43,'No ',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (111,'Mark', 'L', 'Harrington', 'Quality Assurance Technician', '05/31/1976', 'S', 'M', '02/16/1999', 15707.96,83,61,'No ',41,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (114,'Gigi', 'N', 'Matthew', 'Research and Development Engineer', '02/21/1969', 'M', 'F', '02/17/1999', 102000.04,63,51,'Yes',158,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (117,'Franois', 'P', 'Ajenstat', 'Database Administrator', '06/17/1965', 'S', 'M', '02/18/1999', 57119.94,67,53,'Yes',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (119,'Jill', 'A', 'Williams', 'Marketing Specialist', '07/19/1969', 'M', 'F', '02/19/1999', 30000.05,47,43,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (121,'Matthias', 'T', 'Berndt', 'Shipping and Receiving Clerk', '12/13/1963', 'M', 'M', '02/21/1999', 105000.06,94,67,'Yes',85,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (128,'Dan', 'B', 'Dugle', 'Database Administrator', '02/06/1966', 'M', 'M', '02/23/1999', 29988.00,66,53,'Yes',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (130,'Bryan', 'A', 'Walton', 'Accounts Receivable Specialist', '10/22/1974', 'S', 'M', '02/25/1999', 40310.40,62,51,'Yes',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (132,'Sairaj', 'L', 'Uddin', 'Scheduling Assistant', '01/22/1978', 'M', 'M', '02/27/1999', 28288.00,46,43,'Yes',44,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (139,'David', 'J', 'Liu', 'Accounts Manager', '08/08/1973', 'M', 'M', '03/03/1999', 73695.05,57,48,'Yes',140,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (140,'Laura', 'F', 'Norman', 'Chief Financial Officer', '02/06/1966', 'M', 'F', '03/04/1999', 52809.12,0,20,'Yes',109,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (145,'Andreas', 'T', 'Berglund', 'Quality Assurance Technician', '04/29/1979', 'M', 'M', '03/06/1999', 15707.96,84,62,'Yes',41,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (148,'James', 'R', 'Hamilton', 'Vice President of Production', '02/07/1973', 'S', 'M', '03/07/1999', 186382.56,64,52,'Yes',109,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (149,'Ramesh', 'V', 'Meyyappan', 'Application Specialist', '04/14/1978', 'S', 'M', '03/07/1999', 50872.41,73,56,'Yes',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (150,'Stephanie', 'A', 'Conroy', 'Network Manager', '04/26/1974', 'S', 'F', '03/08/1999', 69300.07,68,54,'No ',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (154,'Hao', 'O', 'Chen', 'Human Resources Administrative Assistant', '05/19/1967', 'S', 'M', '03/10/1999', 44369.97,52,46,'Yes',30,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (158,'Dylan', 'A', 'Miller', 'Research and Development Manager', '03/27/1977', 'M', 'M', '03/12/1999', 107100.06,61,50,'Yes',3,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (164,'Mikael', 'Q', 'Sandberg', 'Buyer', '09/18/1974', 'S', 'M', '03/14/1999', 38759.94,59,49,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (166,'Dragan', 'K', 'Tomic', 'Accounts Payable Specialist', '03/18/1967', 'M', 'M', '03/15/1999', 40310.40,63,51,'Yes',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (170,'Alan', 'J', 'Brewer', 'Scheduling Assistant', '04/30/1974', 'M', 'M', '03/17/1999', 28288.00,47,43,'Yes',44,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (176,'Karen', 'A', 'Berg', 'Application Specialist', '06/19/1968', 'S', 'F', '03/20/1999', 35909.94,74,57,'Yes',42,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (178,'Barbara', 'C', 'Moreland', 'Accountant', '02/04/1966', 'M', 'F', '03/22/1999', 65999.98,58,49,'Yes',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (188,'Peter', 'I', 'Connelly', 'Network Administrator', '06/29/1970', 'S', 'M', '03/27/1999', 48194.96,69,54,'Yes',150,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (191,'Grant', 'N', 'Culbertson', 'Human Resources Administrative Assistant', '05/18/1966', 'S', 'M', '03/29/1999', 29579.98,53,46,'Yes',30,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (195,'Jimmy', 'T', 'Bischoff', 'Stocker', '06/05/1975', 'M', 'M', '03/30/1999', 13366.08,96,68,'Yes',85,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (198,'Arvind', 'B', 'Rao', 'Buyer', '09/21/1964', 'M', 'M', '04/01/1999', 29069.95,60,50,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (200,'Hazem', 'E', 'Dudenhoefer', 'Quality Assurance Manager', '11/27/1967', 'S', 'M', '04/01/1999', 42840.07,80,60,'Yes',148,'01/26/2005')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (201,'Janet', 'L', 'Smith', 'Accounts Payable Specialist', '04/09/1969', 'M', 'F', '04/02/1999', 47424.00,64,52,'Yes',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (203,'Terry', 'J', 'Eminhizer', 'Marketing Specialist', '03/07/1976', 'M', 'M', '04/03/1999', 25500.04,44,42,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (206,'Brian', 'P', 'LaMee', 'Scheduling Assistant', '09/12/1974', 'M', 'M', '04/04/1999', 28288.00,48,44,'Yes',44,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (212,'Chris', 'K', 'Norred', 'Control Specialist', '06/26/1977', 'M', 'M', '04/07/1999', 24989.96,75,57,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (216,'Mike', 'K', 'Seamans', 'Accountant', '08/01/1969', 'S', 'M', '04/09/1999', 56099.98,59,49,'Yes',139,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (217,'Michael', Null, 'Raheem', 'Research and Development Manager', '01/01/1975', 'M', 'M', '06/04/1999', 48818.93,16,64,'Yes',158,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (218,'Gary', 'E.', 'Altman', 'Facilities Manager', '03/21/1961', 'M', 'M', '01/03/2000', 35700.06,86,63,'Yes',148,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (223,'Linda', 'P', 'Meisner', 'Buyer', '12/31/1960', 'M', 'F', '01/18/2000', 45599.93,56,48,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (225,'Magnus', 'E', 'Hedlund', 'Facilities Administrative Assistant', '09/27/1961', 'M', 'M', '01/22/2000', 14479.92,87,63,'Yes',218,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (231,'Fukiko', 'J', 'Ogisu', 'Buyer', '12/25/1960', 'M', 'M', '02/05/2000', 54263.91,57,48,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (233,'Gladys', 'L', 'Hee', 'Buyer', '12/30/1956', 'M', 'F', '02/12/2000', 56999.91,52,46,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (238,'Frank', 'S', 'Pellow', 'Buyer', '06/13/1942', 'M', 'M', '02/24/2000', 31007.95,58,49,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (241,'Eric', 'S', 'Kurjan', 'Buyer', '10/19/1962', 'S', 'M', '02/28/2000', 19379.97,54,47,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (242,'Pat', 'H', 'Coleman', 'Janitor', '01/03/1961', 'S', 'M', '02/28/2000', 13737.36,89,64,'Yes',49,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (244,'Erin', 'M', 'Hagens', 'Buyer', '02/04/1961', 'S', 'F', '03/03/2000', 56999.91,53,46,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (251,'Lori', 'K', 'Penor', 'Janitor', '08/31/1960', 'M', 'F', '03/19/2000', 16161.60,90,65,'Yes',49,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (253,'Sootha', 'T', 'Charncherngkha', 'Quality Assurance Technician', '01/05/1957', 'M', 'M', '03/26/2000', 15707.96,85,62,'Yes',41,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (259,'Stuart', 'J', 'Macrae', 'Janitor', '01/17/1962', 'M', 'M', '04/05/2000', 13737.36,88,64,'Yes',49,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (260,'Jo', 'L', 'Berry', 'Janitor', '05/25/1944', 'M', 'F', '04/07/2000', 16161.60,91,65,'Yes',49,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (261,'Ben', 'T', 'Miller', 'Buyer', '07/05/1963', 'M', 'M', '04/09/2000', 38759.94,55,47,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (264,'Annette', 'L', 'Hill', 'Purchasing Assistant', '03/01/1968', 'M', 'F', '01/06/2001', 26520.00,50,45,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (265,'Janice', 'M', 'Galvin', 'Tool Designer', '06/29/1979', 'M', 'F', '01/23/2001', 33800.00,8,24,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (266,'Reinout', 'N', 'Hillmann', 'Purchasing Assistant', '02/18/1968', 'M', 'M', '01/25/2001', 27050.40,51,45,'Yes',274,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (267,'Michael', 'I', 'Sullivan', 'Senior Design Engineer', '07/17/1969', 'S', 'M', '01/30/2001', 41437.51,3,21,'Yes',3,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (269,'Wanida', 'M', 'Benshoof', 'Marketing Assistant', '04/17/1965', 'M', 'F', '02/07/2001', 27999.92,41,40,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (270,'Sharon', 'B', 'Salavaria', 'Design Engineer', '06/03/1951', 'M', 'F', '02/18/2001', 44199.99,4,22,'Yes',3,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (271,'John', 'L', 'Wood', 'Marketing Specialist', '04/06/1968', 'S', 'M', '03/10/2001', 25500.04,48,44,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (272,'Mary', 'A', 'Dempsey', 'Marketing Assistant', '03/01/1968', 'S', 'F', '03/17/2001', 27999.92,43,41,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (273,'Brian', 'S', 'Welcker', 'Vice President of Sales', '07/08/1967', 'S', 'M', '03/18/2001', 107100.02,93,25,'Yes',109,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (274,'Sheela', 'H', 'Word', 'Purchasing Manager', '03/13/1968', 'S', 'F', '03/28/2001', 20508.80,49,44,'Yes',71,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (275,'Michael', 'G', 'Smith', 'Sales Representative', '01/26/1959', 'S', 'M', '07/01/2001', 26519.97,38,39,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (276,'Linda', 'C', 'Mitchell', 'Sales Representative', '03/30/1970', 'M', 'F', '07/01/2001', 31199.97,27,33,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (277,'Jillian', Null, 'Carson', 'Sales Representative', '09/29/1952', 'S', 'F', '07/01/2001', 31199.97,24,32,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (278,'Garrett', 'R', 'Vargas', 'Sales Representative', '03/07/1965', 'M', 'M', '07/01/2001', 26519.97,33,36,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (279,'Tsvi', 'Michael', 'Reiter', 'Sales Representative', '02/19/1964', 'M', 'M', '07/01/2001', 26519.97,29,34,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (280,'Pamela', 'O', 'Ansman-Wolfe', 'Sales Representative', '01/06/1965', 'S', 'F', '07/01/2001', 31199.97,22,31,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (281,'Shu', 'K', 'Ito', 'Sales Representative', '04/10/1958', 'M', 'M', '07/01/2001', 26519.97,26,33,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (282,'Jos', 'Edvaldo', 'Saraiva', 'Sales Representative', '01/11/1954', 'M', 'M', '07/01/2001', 26519.97,31,35,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (283,'David', 'R', 'Campbell', 'Sales Representative', '03/14/1964', 'S', 'M', '07/01/2001', 26519.97,23,31,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (284,'Amy', 'E', 'Alberts', 'European Sales Manager', '10/22/1947', 'M', 'F', '05/18/2002', 113749.98,21,30,'Yes',273,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (285,'Jae', 'B', 'Pak', 'Sales Representative', '04/18/1958', 'M', 'F', '07/01/2002', 31199.97,37,38,'Yes',284,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (287,'Tete', 'A', 'Mensa-Annan', 'Sales Representative', '02/06/1968', 'M', 'M', '11/01/2002', 26519.97,39,39,'Yes',6,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (288,'Syed', 'E', 'Abbas', 'Pacific Sales Manager', '02/11/1965', 'M', 'M', '04/15/2003', 55277.67,20,30,'Yes',273,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (289,'Rachel', 'B', 'Valdez', 'Sales Representative', '08/09/1965', 'S', 'F', '07/01/2003', 31199.97,35,37,'Yes',284,'07/31/2004')
INSERT INTO Employees (EMPLOYEEID,FIRSTNAME,MIDDLENAME,LASTNAME,TITLE,BIRTHDATE,MARITALSTATUS,GENDER,HIREDATE,SALARY, VacationHours,SickLeaveHours,Active,ManagerID,ModifiedDate) VALUES (290,'Lynn', 'N', 'Tsoflias', 'Sales Representative', '04/18/1961', 'S', 'F', '07/01/2003', 31199.97,36,38,'Yes',288,'07/31/2004')


SET IDENTITY_INSERT EMPLOYEES OFF


/********************************************************************************************/

/****** Object:  Table [dbo].[EmployeesEmployeesDependents]    Script Date: 08/14/2013 20:29:42 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[EmployeesDependents](
	[DependentID] [int] IDENTITY(1,1) NOT NULL,
	[EmployeeID] [int] NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NULL,
	[Gender] [char](1) NULL,
	[BirthDate] [date] NULL,
 CONSTRAINT [PK_EmployeesEmployeesDependents] PRIMARY KEY CLUSTERED 
(
	[DependentID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[EmployeesDependents]  WITH CHECK ADD  CONSTRAINT [FK_EmployeesDependents] FOREIGN KEY([EmployeeID])
REFERENCES [dbo].[Employees] ([EmployeeID])
GO

ALTER TABLE [dbo].[EmployeesDependents] CHECK CONSTRAINT [FK_EmployeesDependents]
GO





INSERT INTO EmployeesDependents VALUES (9,'Martha', 'S', 'Erickson', 'F', '06/07/2010')
INSERT INTO EmployeesDependents VALUES (9,'William', 'M', 'Erickson', 'M', '11/02/2008')
INSERT INTO EmployeesDependents VALUES (34,'Michael', 'T', 'Eaton', 'M', '07/01/2005')
INSERT INTO EmployeesDependents VALUES (72,'Robert', Null, 'Ralls', 'M', '04/25/1999')
INSERT INTO EmployeesDependents VALUES (72,'Marcia', 'A', 'Ralls', 'F', '09/17/1998')
INSERT INTO EmployeesDependents VALUES (72,'Barbara', 'C', 'Ralls', 'F', '11/12/2001')
INSERT INTO EmployeesDependents VALUES (72,'Theodore', Null, 'Ralls', 'M', '08/01/2005')
INSERT INTO EmployeesDependents VALUES (72,'Patricia', 'M', 'Ralls', 'F', '12/22/2003')
INSERT INTO EmployeesDependents VALUES (96,'Samuel', Null, 'Vong', 'M', '04/01/1995')
INSERT INTO EmployeesDependents VALUES (96,'Heidi', Null, 'Vong', 'F', '10/07/1997')
INSERT INTO EmployeesDependents VALUES (96,'Wendy', Null, 'Vong', 'F', '08/27/1999')
INSERT INTO EmployeesDependents VALUES (102,'Joseph', 'L', 'Bacon', 'M', '08/07/1993')
INSERT INTO EmployeesDependents VALUES (94,'Christopher', 'A', 'Spoon', 'M', '02/17/1994')
INSERT INTO EmployeesDependents VALUES (94,'Jason', 'P', 'Spoon', 'M', '07/21/1995')
INSERT INTO EmployeesDependents VALUES (71,'Sheila', 'M', 'Kahn', 'F', '08/22/1997')
INSERT INTO EmployeesDependents VALUES (71,'Carla', 'C', 'Kahn', 'F', '12/02/1998')
INSERT INTO EmployeesDependents VALUES (71,'Maria', 'N', 'Kahn', 'F', '08/01/2000')

/****** Object:  Table [dbo].[Departments]    Script Date: 08/14/2013 20:25:04 ******/
SET ANSI_NULLS ON
GO



SET QUOTED_IDENTIFIER ON
GO



CREATE TABLE [dbo].[Departments](
	[DepartmentID] [smallint] IDENTITY(1,1) NOT NULL,
	[DepartmentName] [varchar](50) NOT NULL,
	[GroupName] [varchar](50) NOT NULL,
	[ModifiedDate] [datetime] NOT NULL,
 CONSTRAINT [PK_Departments] PRIMARY KEY CLUSTERED 
(
	[DepartmentID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO




INSERT INTO DEPARTMENTS VALUES ('Engineering', 'Research and Development','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Tool Design', 'Research and Development','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Sales', 'Sales and Marketing','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Marketing', 'Sales and Marketing','06/01/1998')
INSERT INTO DEPARTMENTs VALUES ('Purchasing', 'Inventory Management','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Research and Development', 'Research and Development','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Production', 'Manufacturing','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Production Control', 'Manufacturing','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Human Resources', 'Executive General and Administration','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Finance', 'Executive General and Administration','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Information Services', 'Executive General and Administration','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Document Control', 'Quality Assurance','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Quality Assurance', 'Quality Assurance','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Facilities and Maintenance', 'Executive General and Administration','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Shipping and Receiving', 'Inventory Management','06/01/1998')
INSERT INTO DEPARTMENTS VALUES ('Executive', 'Executive General and Administration','06/01/1998')


CREATE TABLE [dbo].[EmployeesDepartments](
	[EmployeeID] [int] NOT NULL,
	[DepartmentID] [smallint] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[EndDate] [datetime] NULL,
	[ModifiedDate] [datetime] NOT NULL,
 CONSTRAINT [PK_EmployeesDepartments] PRIMARY KEY CLUSTERED 
(
	[EmployeeID] ASC,
	[DepartmentID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[EmployeesDepartments]  WITH CHECK ADD  CONSTRAINT [FK_EmployeesDepartments_Departments] FOREIGN KEY([DepartmentID])
REFERENCES [dbo].[Departments] ([DepartmentID])
GO

ALTER TABLE [dbo].[EmployeesDepartments] CHECK CONSTRAINT [FK_EmployeesDepartments_Departments]
GO

ALTER TABLE [dbo].[EmployeesDepartments]  WITH CHECK ADD  CONSTRAINT [FK_EmployeesDepartments_Employees] FOREIGN KEY([EmployeeID])
REFERENCES [dbo].[Employees] ([EmployeeID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[EmployeesDepartments] CHECK CONSTRAINT [FK_EmployeesDepartments_Employees]
GO





INSERT INTO EmployeesDepartments values (2,4,'02/26/1997',NULL,'02/25/1997')
INSERT INTO EmployeesDepartments values (3,1,'12/12/1997',NULL,'12/11/1997')
INSERT INTO EmployeesDepartments values (3,2,'04/01/1992','12/11/1997','12/01/1997')
INSERT INTO EmployeesDepartments values (3,15,'03/12/1990','03/31/1992','03/31/1992')
INSERT INTO EmployeesDepartments values (5,2,'01/11/1998',NULL,'01/10/1998')
INSERT INTO EmployeesDepartments values (6,4,'08/16/1999',NULL,'08/15/1999')
INSERT INTO EmployeesDepartments values (6,5,'01/20/1998','08/15/1999','08/13/1999')
INSERT INTO EmployeesDepartments values (9,1,'02/06/1998',NULL,'02/05/1998')
INSERT INTO EmployeesDepartments values (9,2,'12/12/1991','07/31/1993','07/01/1993')
INSERT INTO EmployeesDepartments values (9,13,'08/01/1993','02/05/1998','02/01/1998')
INSERT INTO EmployeesDepartments values (11,1,'02/24/1998',NULL,'02/23/1998')
INSERT INTO EmployeesDepartments values (12,1,'03/03/1998',NULL,'03/02/1998')
INSERT INTO EmployeesDepartments values (28,11,'01/05/1999',NULL,'01/04/1999')
INSERT INTO EmployeesDepartments values (30,9,'01/07/1999',NULL,'01/06/1999')
INSERT INTO EmployeesDepartments values (34,15,'01/08/1999',NULL,'01/07/1999')
INSERT INTO EmployeesDepartments values (35,15,'01/08/1999',NULL,'01/07/1999')
INSERT INTO EmployeesDepartments values (41,13,'01/10/1999',NULL,'01/09/1999')
INSERT INTO EmployeesDepartments values (42,11,'01/12/1999',NULL,'01/11/1999')
INSERT INTO EmployeesDepartments values (44,8,'01/13/1999',NULL,'01/12/1999')
INSERT INTO EmployeesDepartments values (46,4,'01/13/1999',NULL,'01/12/1999')
INSERT INTO EmployeesDepartments values (47,9,'01/14/1999',NULL,'01/13/1999')
INSERT INTO EmployeesDepartments values (49,14,'01/15/1999',NULL,'01/14/1999')
INSERT INTO EmployeesDepartments values (54,12,'01/17/1999',NULL,'01/16/1999')
INSERT INTO EmployeesDepartments values (59,10,'01/19/1999',NULL,'01/18/1999')
INSERT INTO EmployeesDepartments values (66,11,'01/24/1999',NULL,'01/23/1999')
INSERT INTO EmployeesDepartments values (70,9,'01/26/1999',NULL,'01/25/1999')
INSERT INTO EmployeesDepartments values (71,10,'01/26/1999',NULL,'01/25/1999')
INSERT INTO EmployeesDepartments values (72,15,'01/27/1999',NULL,'01/26/1999')
INSERT INTO EmployeesDepartments values (77,13,'01/29/1999',NULL,'01/28/1999')
INSERT INTO EmployeesDepartments values (79,6,'01/30/1999',NULL,'01/29/1999')
INSERT INTO EmployeesDepartments values (82,9,'02/02/1999',NULL,'02/01/1999')
INSERT INTO EmployeesDepartments values (85,15,'02/03/1999',NULL,'02/02/1999')
INSERT INTO EmployeesDepartments values (94,10,'02/07/1999',NULL,'02/06/1999')
INSERT INTO EmployeesDepartments values (96,7,'02/08/1999','10/01/2001','09/29/2001')
INSERT INTO EmployeesDepartments values (96,8,'10/02/2001',NULL,'10/01/2001')
INSERT INTO EmployeesDepartments values (102,11,'02/12/1999',NULL,'02/11/1999')
INSERT INTO EmployeesDepartments values (106,4,'02/13/1999',NULL,'02/12/1999')
INSERT INTO EmployeesDepartments values (111,13,'02/16/1999',NULL,'02/15/1999')
INSERT INTO EmployeesDepartments values (114,6,'02/17/1999',NULL,'02/16/1999')
INSERT INTO EmployeesDepartments values (117,11,'02/18/1999',NULL,'02/17/1999')
INSERT INTO EmployeesDepartments values (119,4,'02/19/1999',NULL,'02/18/1999')
INSERT INTO EmployeesDepartments values (121,15,'02/21/1999',NULL,'02/20/1999')
INSERT INTO EmployeesDepartments values (128,11,'02/23/1999',NULL,'02/22/1999')
INSERT INTO EmployeesDepartments values (130,10,'02/25/1999',NULL,'02/24/1999')
INSERT INTO EmployeesDepartments values (132,8,'02/27/1999',NULL,'02/26/1999')
INSERT INTO EmployeesDepartments values (139,10,'03/03/1999',NULL,'03/02/1999')
INSERT INTO EmployeesDepartments values (140,10,'03/04/1999','12/15/2003','12/13/2003')
INSERT INTO EmployeesDepartments values (140,16,'12/16/2003',NULL,'12/15/2003')
INSERT INTO EmployeesDepartments values (145,13,'03/06/1999',NULL,'03/05/1999')
INSERT INTO EmployeesDepartments values (148,7,'03/07/1999',NULL,'03/06/1999')
INSERT INTO EmployeesDepartments values (149,11,'03/07/1999',NULL,'03/06/1999')
INSERT INTO EmployeesDepartments values (150,11,'03/08/1999',NULL,'03/07/1999')
INSERT INTO EmployeesDepartments values (154,9,'03/10/1999',NULL,'03/09/1999')
INSERT INTO EmployeesDepartments values (158,6,'03/12/1999',NULL,'03/11/1999')
INSERT INTO EmployeesDepartments values (164,5,'03/14/1999',NULL,'03/13/1999')
INSERT INTO EmployeesDepartments values (166,10,'03/15/1999',NULL,'03/14/1999')
INSERT INTO EmployeesDepartments values (170,8,'03/17/1999',NULL,'03/16/1999')
INSERT INTO EmployeesDepartments values (176,11,'03/20/1999',NULL,'03/19/1999')
INSERT INTO EmployeesDepartments values (178,10,'03/22/1999',NULL,'03/21/1999')
INSERT INTO EmployeesDepartments values (188,11,'03/27/1999',NULL,'03/26/1999')
INSERT INTO EmployeesDepartments values (191,9,'03/29/1999',NULL,'03/28/1999')
INSERT INTO EmployeesDepartments values (195,15,'03/30/1999',NULL,'03/29/1999')
INSERT INTO EmployeesDepartments values (198,5,'04/01/1999',NULL,'03/31/1999')
INSERT INTO EmployeesDepartments values (200,13,'04/01/1999',NULL,'03/31/1999')
INSERT INTO EmployeesDepartments values (201,10,'04/02/1999',NULL,'04/01/1999')
INSERT INTO EmployeesDepartments values (203,4,'04/03/1999',NULL,'04/02/1999')
INSERT INTO EmployeesDepartments values (206,8,'04/04/1999',NULL,'04/03/1999')
INSERT INTO EmployeesDepartments values (212,12,'04/07/1999',NULL,'04/06/1999')
INSERT INTO EmployeesDepartments values (216,10,'04/09/1999',NULL,'04/08/1999')
INSERT INTO EmployeesDepartments values (217,6,'06/04/1999',NULL,'06/03/1999')
INSERT INTO EmployeesDepartments values (218,14,'01/03/2000',NULL,'01/02/2000')
INSERT INTO EmployeesDepartments values (223,5,'01/18/2000',NULL,'01/17/2000')
INSERT INTO EmployeesDepartments values (225,14,'01/22/2000',NULL,'01/21/2000')
INSERT INTO EmployeesDepartments values (231,5,'02/05/2000',NULL,'02/04/2000')
INSERT INTO EmployeesDepartments values (233,5,'02/12/2000',NULL,'02/11/2000')
INSERT INTO EmployeesDepartments values (238,5,'02/24/2000',NULL,'02/23/2000')
INSERT INTO EmployeesDepartments values (241,5,'02/28/2000',NULL,'02/27/2000')
INSERT INTO EmployeesDepartments values (242,14,'02/28/2000',NULL,'02/27/2000')
INSERT INTO EmployeesDepartments values (244,5,'03/03/2000',NULL,'03/02/2000')
INSERT INTO EmployeesDepartments values (251,14,'03/19/2000',NULL,'03/18/2000')
INSERT INTO EmployeesDepartments values (253,13,'03/26/2000',NULL,'03/25/2000')
INSERT INTO EmployeesDepartments values (259,14,'04/05/2000',NULL,'04/04/2000')
INSERT INTO EmployeesDepartments values (260,14,'04/07/2000',NULL,'04/06/2000')
INSERT INTO EmployeesDepartments values (261,5,'04/09/2000',NULL,'04/08/2000')
INSERT INTO EmployeesDepartments values (264,5,'01/06/2001',NULL,'01/05/2001')
INSERT INTO EmployeesDepartments values (265,2,'01/23/2001',NULL,'01/22/2001')
INSERT INTO EmployeesDepartments values (266,5,'01/25/2001',NULL,'01/24/2001')
INSERT INTO EmployeesDepartments values (267,1,'01/30/2001',NULL,'01/29/2001')
INSERT INTO EmployeesDepartments values (269,4,'02/07/2001',NULL,'02/06/2001')
INSERT INTO EmployeesDepartments values (270,1,'02/18/2001',NULL,'02/17/2001')
INSERT INTO EmployeesDepartments values (271,4,'03/10/2001',NULL,'03/09/2001')
INSERT INTO EmployeesDepartments values (272,4,'03/17/2001',NULL,'03/16/2001')
INSERT INTO EmployeesDepartments values (273,3,'03/18/2001',NULL,'03/17/2001')
INSERT INTO EmployeesDepartments values (274,4,'03/28/2001','08/30/2001','08/28/2001')
INSERT INTO EmployeesDepartments values (274,5,'08/16/2002',NULL,'08/15/2002')
INSERT INTO EmployeesDepartments values (274,13,'08/31/2001','08/15/2002','08/13/2002')
INSERT INTO EmployeesDepartments values (275,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (276,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (277,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (278,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (279,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (280,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (281,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (282,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (283,3,'07/01/2001',NULL,'06/30/2001')
INSERT INTO EmployeesDepartments values (284,3,'05/18/2002',NULL,'05/17/2002')
INSERT INTO EmployeesDepartments values (285,3,'07/01/2002',NULL,'06/30/2002')
INSERT INTO EmployeesDepartments values (287,3,'11/01/2002',NULL,'10/31/2002')
INSERT INTO EmployeesDepartments values (288,3,'04/15/2003',NULL,'04/14/2003')
INSERT INTO EmployeesDepartments values (289,3,'07/01/2003',NULL,'06/30/2003')
INSERT INTO EmployeesDepartments values (290,3,'07/01/2003',NULL,'06/30/2003')



/****** Object:  Table [dbo].[Departments]    Script Date: 08/14/2013 19:53:40 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

/****** Object:  Table [dbo].[Addresses]    Script Date: 08/14/2013 20:14:10 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[Addresses](
	[AddressesID] [int] IDENTITY(1,1) NOT NULL,
	[EmployeeID] [int] NULL,
	[AddressLine1] [varchar](60) NOT NULL,
	[AddressLine2] [varchar](60) NULL,
	[City] [varchar](50) NOT NULL,
	[State] [char](2) NOT NULL,
	[Zip1] [char](5) NOT NULL,
	[Zip2] [char](4) NULL,
	[ModifiedDate] [datetime] NOT NULL,
 CONSTRAINT [PK_ADDRESSES] PRIMARY KEY CLUSTERED 
(
	[AddressesID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[Addresses]  WITH CHECK ADD  CONSTRAINT [FK_Addresses_Employees] FOREIGN KEY([EmployeeID])
REFERENCES [dbo].[Employees] ([EmployeeID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[Addresses] CHECK CONSTRAINT [FK_Addresses_Employees]
GO


INSERT INTO ADDRESSES VALUES(5,'1970 Napa Ct.',Null, 'Bothell',  'WA', '98011','9288','01/04/1998')
INSERT INTO ADDRESSES VALUES(35,'9833 Mt. Dias Blv.',Null, 'Bothell',  'WA', '98011','9288','01/01/1999')
INSERT INTO ADDRESSES VALUES(288,'7484 Roundtree Drive',Null, 'Bothell',  'WA', '98011','9288','04/08/2003')
INSERT INTO ADDRESSES VALUES(164,'9539 Glenside Dr',Null, 'Bothell',  'WA', '98011','9288','03/07/1999')
INSERT INTO ADDRESSES VALUES(72,'1226 Shoe St.',Null, 'Bothell',  'WA', '98011','9288','01/20/1999')
INSERT INTO ADDRESSES VALUES(41,'250 Race Court',Null, 'Bothell',  'WA', '98011','9288','01/03/1999')
INSERT INTO ADDRESSES VALUES(280,'636 Vine Hill Way',Null, 'Portland',  'OR', '97205',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(277,'80 Sunview Terrace',Null, 'Duluth',  'MN', '55802',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(281,'5725 Glaze Drive',Null, 'San Francisco',  'CA', '94109',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(276,'2487 Riverside Drive',Null, 'Nevada',  'UT', '84407',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(279,'8291 Crossbow Way',Null, 'Memphis',  'TN', '38103',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(282,'9100 Sheppard Avenue North',Null, 'Ottawa',  'ON', 'K4B 1',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(278,'10203 Acorn Avenue',Null, 'Calgary',  'AB', 'T2P 2',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(289,'Pascalstr 951',Null, 'London',  'UK', '14111',Null,'06/24/2003')
INSERT INTO ADDRESSES VALUES(290,'34 Waterloo Road',Null, 'Melbourne',  'MA', '3000 ',Null,'06/24/2003')
INSERT INTO ADDRESSES VALUES(285,'Downshire Way',Null, 'Cambridge',  'MA', 'BA5 3',Null,'06/24/2002')
INSERT INTO ADDRESSES VALUES(275,'8154 Via Mexico',Null, 'Detroit',  'MI', '48226',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(287,'3997 Via De Luna',Null, 'Cambridge',  'MA', '02139',Null,'10/25/2002')
INSERT INTO ADDRESSES VALUES(158,'7048 Laurel',Null, 'Kenmore',  'WA', '98028',Null,'03/05/1999')
INSERT INTO ADDRESSES VALUES(170,'25 95th Ave NE',Null, 'Kenmore',  'WA', '98028',Null,'03/10/1999')
INSERT INTO ADDRESSES VALUES(148,'9652 Los Angeles',Null, 'Monroe',  'WA', '98272',Null,'02/28/1999')
INSERT INTO ADDRESSES VALUES(203,'8668 Via Neruda',Null, 'Bellevue',  'WA', '98004',Null,'03/27/1999')
INSERT INTO ADDRESSES VALUES(266,'620 Woodside Ct.',Null, 'Bellevue',  'WA', '98004',Null,'01/18/2001')
INSERT INTO ADDRESSES VALUES(272,'6307 Greenbelt Way',Null, 'Bellevue',  'WA', '98004',Null,'03/10/2001')
INSERT INTO ADDRESSES VALUES(231,'8751 Norse Drive',Null, 'Bellevue',  'WA', '98004',Null,'01/29/2000')
INSERT INTO ADDRESSES VALUES(30,'4311 Clay Rd',Null, 'Bellevue',  'WA', '98004',Null,'12/31/1998')
INSERT INTO ADDRESSES VALUES(244,'2947 Vine Lane',Null, 'Bellevue',  'WA', '98004',Null,'02/25/2000')
INSERT INTO ADDRESSES VALUES(223,'6118 Grasswood Circle',Null, 'Bellevue',  'WA', '98004',Null,'01/11/2000')
INSERT INTO ADDRESSES VALUES(114,'7808 Brown St.',Null, 'Bellevue',  'WA', '98004',Null,'02/10/1999')
INSERT INTO ADDRESSES VALUES(96,'6774 Bonanza',Null, 'Bellevue',  'WA', '98004',Null,'02/01/1999')
INSERT INTO ADDRESSES VALUES(9,'9435 Breck Court',Null, 'Bellevue',  'WA', '98004',Null,'01/30/1998')
INSERT INTO ADDRESSES VALUES(269,'6951 Harmony Way',Null, 'Sammamish',  'WA', '98074',Null,'01/31/2001')
INSERT INTO ADDRESSES VALUES(201,'6871 Thornwood Dr.',Null, 'Sammamish',  'WA', '98074',Null,'03/26/1999')
INSERT INTO ADDRESSES VALUES(71,'4525 Benedict Ct.',Null, 'Sammamish',  'WA', '98074',Null,'01/19/1999')
INSERT INTO ADDRESSES VALUES(271,'9906 Oak Grove Road',Null, 'Redmond',  'WA', '98052','4211','03/03/2001')
INSERT INTO ADDRESSES VALUES(42,'2383 Pepper Drive',Null, 'Redmond',  'WA', '98052','4211','01/05/1999')
INSERT INTO ADDRESSES VALUES(264,'6369 Ellis Street',Null, 'Redmond',  'WA', '98052','4211','12/30/2000')
INSERT INTO ADDRESSES VALUES(6,'3768 Door Way',Null, 'Redmond',  'WA', '98052','4211','01/13/1998')
INSERT INTO ADDRESSES VALUES(261,'101 Candy Rd.',Null, 'Redmond',  'WA', '98052','4211','04/02/2000')
INSERT INTO ADDRESSES VALUES(265,'3397 Rancho View Drive',Null, 'Redmond',  'WA', '98052','4211','01/16/2001')
INSERT INTO ADDRESSES VALUES(3,'2137 Birchwood Dr',Null, 'Redmond',  'WA', '98052','4211','12/05/1997')
INSERT INTO ADDRESSES VALUES(106,'3928 San Francisco',Null, 'Everett',  'WA', '98201',Null,'02/06/1999')
INSERT INTO ADDRESSES VALUES(79,'475 Santa Maria',Null, 'Everett',  'WA', '98201',Null,'01/23/1999')
INSERT INTO ADDRESSES VALUES(46,'1185 Dallas Drive',Null, 'Everett',  'WA', '98201',Null,'01/06/1999')
INSERT INTO ADDRESSES VALUES(2,'7883 Missing Canyon Court',Null, 'Everett',  'WA', '98201',Null,'02/19/1997')
INSERT INTO ADDRESSES VALUES(47,'5452 Corte Gilberto',Null, 'Everett',  'WA', '98201',Null,'01/07/1999')
INSERT INTO ADDRESSES VALUES(119,'3238 Laguna Circle',Null, 'Everett',  'WA', '98201',Null,'02/12/1999')
INSERT INTO ADDRESSES VALUES(59,'7640 First Ave.',Null, 'Everett',  'WA', '98201',Null,'01/12/1999')
INSERT INTO ADDRESSES VALUES(206,'2294 West 39th St.',Null, 'Everett',  'WA', '98201',Null,'03/28/1999')
INSERT INTO ADDRESSES VALUES(44,'9297 Kenston Dr.',Null, 'Newport Hills',  'WA', '98006',Null,'01/06/1999')
INSERT INTO ADDRESSES VALUES(70,'9687 Shakespeare Drive',Null, 'Newport Hills',  'WA', '98006',Null,'01/19/1999')
INSERT INTO ADDRESSES VALUES(130,'1397 Paradise Ct.',Null, 'Newport Hills',  'WA', '98006',Null,'02/18/1999')
INSERT INTO ADDRESSES VALUES(82,'3030 Blackburn Ct.',Null, 'Newport Hills',  'WA', '98006',Null,'01/26/1999')
INSERT INTO ADDRESSES VALUES(139,'9605 Pheasant Circle',Null, 'Gold Bar',  'WA', '98251',Null,'02/24/1999')
INSERT INTO ADDRESSES VALUES(242,'2425 Notre Dame Ave',Null, 'Gold Bar',  'WA', '98251',Null,'02/21/2000')
INSERT INTO ADDRESSES VALUES(49,'8036 Summit View Dr.',Null, 'Gold Bar',  'WA', '98251',Null,'01/08/1999')
INSERT INTO ADDRESSES VALUES(191,'213 Stonewood Drive',Null, 'Gold Bar',  'WA', '98251',Null,'03/22/1999')
INSERT INTO ADDRESSES VALUES(166,'3884 Beauty Street','# 14', 'Gold Bar',  'WA', '98251',Null,'03/08/1999')
INSERT INTO ADDRESSES VALUES(260,'1748 Bird Drive',Null, 'Index',  'WA', '98256',Null,'03/31/2000')
INSERT INTO ADDRESSES VALUES(94,'310 Winter Lane',Null, 'Index',  'WA', '98256',Null,'01/31/1999')
INSERT INTO ADDRESSES VALUES(251,'3514 Sunshine',Null, 'Index',  'WA', '98256',Null,'03/12/2000')
INSERT INTO ADDRESSES VALUES(216,'1245 Clay Road',Null, 'Index',  'WA', '98256',Null,'04/02/1999')
INSERT INTO ADDRESSES VALUES(154,'7691 Benedict Ct.','# 141', 'Issaquah',  'WA', '98027',Null,'03/03/1999')
INSERT INTO ADDRESSES VALUES(117,'1144 Paradise Ct.',Null, 'Issaquah',  'WA', '98027',Null,'02/11/1999')
INSERT INTO ADDRESSES VALUES(150,'7435 Ricardo',Null, 'Issaquah',  'WA', '98027',Null,'03/01/1999')
INSERT INTO ADDRESSES VALUES(188,'9530 Vine Lane',Null, 'Issaquah',  'WA', '98027',Null,'03/20/1999')
INSERT INTO ADDRESSES VALUES(28,'6580 Poor Ridge Court',Null, 'Issaquah',  'WA', '98027',Null,'12/29/1998')
INSERT INTO ADDRESSES VALUES(66,'5979 El Pueblo',Null, 'Issaquah',  'WA', '98027',Null,'01/17/1999')
INSERT INTO ADDRESSES VALUES(102,'1921 Ranch Road',Null, 'Issaquah',  'WA', '98027',Null,'02/05/1999')
INSERT INTO ADDRESSES VALUES(149,'3848 East 39th Street',Null, 'Issaquah',  'WA', '98027',Null,'02/28/1999')
INSERT INTO ADDRESSES VALUES(176,'5256 Chickpea Ct.',Null, 'Issaquah',  'WA', '98027',Null,'03/13/1999')
INSERT INTO ADDRESSES VALUES(212,'989 Crown Ct',Null, 'Issaquah',  'WA', '98027',Null,'03/31/1999')
INSERT INTO ADDRESSES VALUES(54,'3333 Madhatter Circle',Null, 'Issaquah',  'WA', '98027',Null,'01/10/1999')
INSERT INTO ADDRESSES VALUES(273,'7772 Golden Meadow',Null, 'Issaquah',  'WA', '98027',Null,'03/11/2001')
INSERT INTO ADDRESSES VALUES(111,'8585 Los Gatos Ct.',Null, 'Issaquah',  'WA', '98027',Null,'02/09/1999')
INSERT INTO ADDRESSES VALUES(77,'7985 Center Street',Null, 'Renton',  'WA', '98055',Null,'01/22/1999')
INSERT INTO ADDRESSES VALUES(238,'5980 Icicle Circle','Unit H', 'Renton',  'WA', '98055',Null,'02/17/2000')
INSERT INTO ADDRESSES VALUES(241,'1378 String Dr',Null, 'Renton',  'WA', '98055',Null,'02/21/2000')
INSERT INTO ADDRESSES VALUES(198,'9495 Limewood Place',Null, 'Renton',  'WA', '98055',Null,'03/25/1999')
INSERT INTO ADDRESSES VALUES(218,'2598 Breck Court',Null, 'Renton',  'WA', '98055',Null,'12/27/1999')
INSERT INTO ADDRESSES VALUES(11,'5670 Bel Air Dr.',Null, 'Renton',  'WA', '98055',Null,'02/17/1998')
INSERT INTO ADDRESSES VALUES(270,'7165 Brock Lane',Null, 'Renton',  'WA', '98055',Null,'02/11/2001')
INSERT INTO ADDRESSES VALUES(34,'2736 Scramble Rd',Null, 'Renton',  'WA', '98055',Null,'01/01/1999')
INSERT INTO ADDRESSES VALUES(259,'2266 Greenwood Circle',Null, 'Renton',  'WA', '98055',Null,'03/29/2000')
INSERT INTO ADDRESSES VALUES(225,'9533 Working Drive',Null, 'Renton',  'WA', '98055',Null,'01/15/2000')
INSERT INTO ADDRESSES VALUES(145,'1803 Olive Hill',Null, 'Renton',  'WA', '98055',Null,'02/27/1999')
INSERT INTO ADDRESSES VALUES(12,'7559 Worth Ct.',Null, 'Renton',  'WA', '98055',Null,'02/24/1998')
INSERT INTO ADDRESSES VALUES(267,'6510 Hacienda Drive',Null, 'Renton',  'WA', '98055',Null,'01/23/2001')
INSERT INTO ADDRESSES VALUES(140,'6937 E. 42nd Street',Null, 'Renton',  'WA', '98055',Null,'02/25/1999')
INSERT INTO ADDRESSES VALUES(195,'2176 Brown Street',Null, 'Renton',  'WA', '98055',Null,'03/23/1999')
INSERT INTO ADDRESSES VALUES(121,'4312 Cambridge Drive',Null, 'Renton',  'WA', '98055',Null,'02/14/1999')
INSERT INTO ADDRESSES VALUES(284,'5009 Orange Street',Null, 'Renton',  'WA', '98055',Null,'05/11/2002')
INSERT INTO ADDRESSES VALUES(217,'1234 Seaside Way',Null, 'San Francisco',  'CA', '94109',Null,'05/28/1999')
INSERT INTO ADDRESSES VALUES(85,'5407 Cougar Way',Null, 'Seattle',  'WA', '98104',Null,'01/27/1999')
INSERT INTO ADDRESSES VALUES(283,'2284 Azalea Avenue',Null, 'Bellevue',  'WA', '98004',Null,'06/24/2001')
INSERT INTO ADDRESSES VALUES(233,'108 Lakeside Court',Null, 'Bellevue',  'WA', '98004',Null,'02/05/2000')
INSERT INTO ADDRESSES VALUES(274,'535 Greendell Pl',Null, 'Sammamish',  'WA', '98074',Null,'03/21/2001')
INSERT INTO ADDRESSES VALUES(253,'4155 Working Drive',Null, 'Kenmore',  'WA', '98028',Null,'03/19/2000')
INSERT INTO ADDRESSES VALUES(200,'5050 Mt. Wilson Way',Null, 'Kenmore',  'WA', '98028',Null,'03/25/1999')
INSERT INTO ADDRESSES VALUES(132,'8040 Hill Ct',Null, 'Redmond',  'WA', '98052','4211','02/20/1999')
INSERT INTO ADDRESSES VALUES(178,'137 Mazatlan',Null, 'Seattle',  'WA', '98104',Null,'03/15/1999')
INSERT INTO ADDRESSES VALUES(128,'5863 Sierra',Null, 'Bellevue',  'WA', '98004',Null,'02/16/1999')




/****** Object:  Table [dbo].[GymMembers]    Script Date: 08/14/2013 20:41:46 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[GymMembers](
	[FirstName] [varchar](30) NULL,
	[LastName] [varchar](30) NULL,
	[DOB] [varchar](10) NULL,
	[ADDRESSES] [varchar](40) NULL,
	[City] [varchar](30) NULL,
	[State] [char](2) NULL,
	[Zip1] [char](5) NULL,
	[Zip2] [char](4) NULL
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO






INSERT INTO GYMMEMBERS VALUES ('Rebecca', 'Mercurio', '20000216', '123 Hollow Road', 'Antonio', 'CA', '95518', '')
INSERT INTO GYMMEMBERS VALUES ('Mike', 'Berel', '19600419', '151 Farmington Avenue', 'Hartford', 'CT', '95570', '1234')
INSERT INTO GYMMEMBERS VALUES ('Jodie', 'Foster', '19811130', '17 East Street', 'Fortuna', 'MA', '95540', '')
INSERT INTO GYMMEMBERS VALUES ('Louise', 'Scott', '19890511', '122 Pointless Road', 'Middletown', 'CT', '95570', '2468')
INSERT INTO GYMMEMBERS VALUES ('Scott', 'Ridgway', '20010817', '1001 Bayhill Drive', 'Arcata', 'CA', '95518', '')
INSERT INTO GYMMEMBERS VALUES ('Sean', 'Combs', '19720520',  '218 Square North St.', 'Trinidad', 'TX', '95570', '8971')
INSERT INTO GYMMEMBERS VALUES ('Rose', 'Burgeo', '19650712', '1002 Look Over Boulevard', 'Sacramento', 'CA', '95525', '')
INSERT INTO GYMMEMBERS VALUES ('Willie', 'Peppin', '19871203',  '10 Day Hill road', 'Bloomfield', 'CT', '95518', '')
INSERT INTO GYMMEMBERS VALUES ('Michael', 'Smith', '19780819',  '100 Ocean Blvd.', 'Los Angele', 'CA', '95503', '')
INSERT INTO GYMMEMBERS VALUES ('Mark', 'Thompson', '19751020',  '230 Pastor Street', 'Port St. Lucie', 'FL', '34952', '')



CREATE TABLE [dbo].[Volunteers](
	[VolunteerID] [int] IDENTITY(1,1) NOT NULL,
	[First] [varchar](35) NOT NULL,
	[Last] [varchar](35) NOT NULL,
	[MI] [char](1) NULL,
	[Sex] [char](1) NOT NULL,
	[DOB] [date] NOT NULL,
 CONSTRAINT [PK_Volunteers] PRIMARY KEY CLUSTERED 
(
	[VolunteerID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]


GO

SET ANSI_PADDING OFF
GO



/******************************************************************************************/
INSERT INTO VOLUNTEERS VALUES   ('Kevin','Brown','F','M','06/03/1977')
INSERT INTO VOLUNTEERS VALUES   ('Roberto','Tamburello',' ','M','12/13/1964')
INSERT INTO VOLUNTEERS VALUES   ('David','Bradley','M','M','04/19/1965')
INSERT INTO VOLUNTEERS VALUES   ('Gail','Erickson','A','F','10/29/1942')
INSERT INTO VOLUNTEERS VALUES   ('Machael','Smith','A','M','04/11/1949')
INSERT INTO VOLUNTEERS VALUES   ('Angela','Dimauro','M','F','09/01/1961')
INSERT INTO VOLUNTEERS VALUES   ('Ashvini','Sharma','R','M','04/28/1967')
INSERT INTO VOLUNTEERS VALUES   ('Paula','Barreto de Mattos','M','F','03/14/1966')
INSERT INTO VOLUNTEERS VALUES   ('Susan','Eaton','W','F','03/20/1968')
INSERT INTO VOLUNTEERS VALUES   ('Vamsi','Kuppa','N','M','04/19/1967')
INSERT INTO VOLUNTEERS VALUES   ('Peng','Wu','J','M','04/19/1966')
INSERT INTO VOLUNTEERS VALUES   ('Fred','Scott','C','M','10/19/1958')
INSERT INTO VOLUNTEERS VALUES   ('Mindy','Martin','C','F','12/22/1974')
INSERT INTO VOLUNTEERS VALUES   ('Wendy','Kahn','B','F','11/12/1974')
INSERT INTO VOLUNTEERS VALUES   ('Kim','Ralls','T','F','06/01/1974')
INSERT INTO VOLUNTEERS VALUES   ('Sean','Alexander','P','M','04/07/1966')
INSERT INTO VOLUNTEERS VALUES   ('Diane','Margheim','L','F','07/06/1976')
INSERT INTO VOLUNTEERS VALUES   ('Toby','McGuire','C','M','09/02/1974')
INSERT INTO VOLUNTEERS VALUES   ('Pilar','Ackerman','G','M','10/11/1962')
INSERT INTO VOLUNTEERS VALUES   ('Joyce','Mennen','L','F','03/26/1966')
INSERT INTO VOLUNTEERS VALUES   ('William','Vong','S','M','12/08/1971')
INSERT INTO VOLUNTEERS VALUES   ('David','Liu','J','M','08/08/1973')
INSERT INTO VOLUNTEERS VALUES   ('Andrea','Norman','F','F','02/06/1966')
INSERT INTO VOLUNTEERS VALUES   ('Margaret','Jackson','T','M','04/29/1979')
INSERT INTO VOLUNTEERS VALUES   ('James','Milsen','R','M','02/07/1973')
INSERT INTO VOLUNTEERS VALUES   ('Jimmy','Bischoff','T','M','06/05/1975')
INSERT INTO VOLUNTEERS VALUES   ('Arvind','Rao','B','M','09/21/1964')
INSERT INTO VOLUNTEERS VALUES   ('Hazem','Dudenhoefer','E','M','11/27/1967')
INSERT INTO VOLUNTEERS VALUES   ('Janet','Smith','L','F','04/09/1969')
INSERT INTO VOLUNTEERS VALUES   ('Terry','Eminhizer','J','M','03/07/1976')
INSERT INTO VOLUNTEERS VALUES   ('Robert','Thompson','P','M','09/12/1974')
INSERT INTO VOLUNTEERS VALUES   ('Tim','Reynolds','K','M','06/26/1977')
INSERT INTO VOLUNTEERS VALUES   ('Mike','Seamans','K','M','08/01/1969')
INSERT INTO VOLUNTEERS VALUES   ('Joseph','Ranson',' ','M','01/01/1975')
INSERT INTO VOLUNTEERS VALUES   ('Mary','Dempsey','A','F','03/01/1968')
/******************************************************************************************/



CREATE TABLE [dbo].[Members](
	[MemberID] [int] IDENTITY(1,1) NOT NULL,
	[First] [varchar](35) NOT NULL,
	[Last] [varchar](35) NOT NULL,
	[MI] [char](1) NULL,
	[Sex] [char](1) NULL,
	[DOB] [date] NULL,
 CONSTRAINT [PK_Members] PRIMARY KEY CLUSTERED 
(
	[MemberID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


/******************************************************************************************/
INSERT INTO MEMBERS VALUES   ('David','Bradley','M','M','04/19/1965')
INSERT INTO MEMBERS VALUES   ('Gail','Erickson','A','F','10/29/1942')
INSERT INTO MEMBERS VALUES   ('Machael','Smith','A','M','04/11/1949')
INSERT INTO MEMBERS VALUES   ('Angela','Dimauro','M','F','09/01/1961')
INSERT INTO MEMBERS VALUES   ('Ashvini','Sharma','R','M','04/28/1967')
INSERT INTO MEMBERS VALUES   ('Paula','Barreto de Mattos','M','F','03/14/1966')
INSERT INTO MEMBERS VALUES   ('Susan','Eaton','W','F','03/20/1968')
INSERT INTO MEMBERS VALUES   ('Vamsi','Kuppa','N','M','04/19/1967')
INSERT INTO MEMBERS VALUES   ('Rebecca','Mercurio',' ','F','04/19/1965')
INSERT INTO MEMBERS VALUES   ('Mike','Berel','A','M','09/22/1964')
INSERT INTO MEMBERS VALUES   ('Jodie','Foster','F','F','09/14/1971')
INSERT INTO MEMBERS VALUES   ('Louise','Scott','C','F','11/01/1975')
INSERT INTO MEMBERS VALUES   ('Scott','Ridgway',' ','M','02/11/1987')
INSERT INTO MEMBERS VALUES   ('Sean','Combs','T','M','05/23/1990')
INSERT INTO MEMBERS VALUES   ('Rose','Burgeo',' ','F','12/24/1985')
INSERT INTO MEMBERS VALUES   ('Willie','Peppin','Z','M','09/12/1971')
INSERT INTO MEMBERS VALUES   ('Michael','Smith','A','M','02/04/1989')
INSERT INTO MEMBERS VALUES   ('Mark','Thompson','E','M','02/01/1988')





/****** Object:  Table [dbo].[GolfCarts]    Script Date: 3/28/2017 7:36:09 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[GolfCarts](
	[CartID] [int] IDENTITY(1,1) NOT NULL,
	[MemberID] [int] NULL,
	[Make] [varchar](25) NULL,
	[Color] [varchar](25) NULL,
	[Year] [int] NULL,
 CONSTRAINT [PK_GolfCarts] PRIMARY KEY CLUSTERED 
(
	[CartID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

SET IDENTITY_INSERT GolfCarts ON

/******************************************************************************************/
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (1, 2, 'Club Car', 'Blue', 2005)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (2, NULL,'Club Car','Red', 2007)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (3, NULL, 'Honda','White', 2003)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (4, 3, 'Toyota','Black', 2009)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (5, 4, 'Honda','Silver', 2008)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (6, Null, 'Club Car','Orange', 2001)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (7, Null, 'Honda','Silver', 2002)
INSERT INTO GolfCarts(CartID,MemberID,Make,Color,Year) VALUES (8, 6, 'Club Car','Green', 2010)


